Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[caves.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[mission0.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		StartBuildPoints	= 6,
		StartBPMultiplier 	= 1.5,
		BPGainMultiplier 	= 1.0,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 11.0,
		DefaultHiveTowerCount = 7,
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 3,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
			[[ZU_NONE]],
			[[ZU_NONE]],
			[[ZU_ZOMBIE_MINES]],
			[[ZU_NONE]],
			[[ZU_REGENERATION]],		
			[[ZU_NONE]],
			[[ZU_WALK_SPEED]],			
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[locked]],
		Active =
		{
		},
		Inactive =
		{
		    [[MU_CHOPPER]],
		},	
		Locked =
		{
		},			
	}
}

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		CaptureAllObjective:Enable()
		
		self:Disable()
	end)
LevelInit:Enable()

------------------------------------------------------------------------------- Dialogue Triggers
DialogueScript = LevelUtils.MakeGoal(
	function (self)
		self.capture_counter = 0
	end,
	
	{[[NT_CAPTURE_RECORD]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        self.capture_counter = self.capture_counter + 1
        
        local texthdl = nil
        if self.capture_counter == 1 then
            texthdl = GameWorld:ShowText("Relax Doc, killing alien buggers is what we do best.\n\nThis looks like an easy run for a change.", "Sarge")
        elseif self.capture_counter == 3 then
            texthdl = GameWorld:ShowText("Unusual changes\n\nThis is what we do best\n\nObserve", "Alien")
        elseif self.capture_counter == 4 then
            texthdl = GameWorld:ShowText("Dammit, had to open my big mouth didn't I.\n\nLooks like the hives are growing mines now.  Doc, are you eggheads reading this?", "Sarge")
        elseif self.capture_counter == 5 then
            texthdl = GameWorld:ShowText("It adapts. Yes.\n\nMore change.", "Alien")
        elseif self.capture_counter == 6 then
            texthdl = GameWorld:ShowText("Drake, I'm reading that the hives are starting to heal themselves.\n\nThe aliens are mutating at a rapid rate.", "Scout")
        elseif self.capture_counter == 7 then
            texthdl = GameWorld:ShowText("Fascinating.  It teaches us much.\n\nMore adaptation.\n\nCome find us in the depths.", "Alien")    
        end
        
        if texthdl then
            ScriptMgr:DoDelayedCall(15000, function () texthdl:ClearText(); end)
        end
      
	end)
DialogueScript:Enable()

------------------------------------------------------------------------------- Tracked objective for capturing everything
CaptureAllObjective = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		GameWorld:AddObjective("winObj", "Capture all the enemy points")
		
		local text_hdl = GameWorld:ShowText("Be careful and keep an eye on anything unusual.", "Scout")
		ScriptMgr:DoDelayedCall(8000, function () text_hdl:ClearText(); end)	
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
	
		self:Disable()
	end)
	
------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		self:Disable()
	end) 
CaptureAllGoal:Enable()

------------------------------------------------------------------------------- Lost all points
LossCondition = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_ALL_POINTS_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[failed]])
	
		GameWorld:ClearText()
		GameWorld:GameOver(false)
	
		CaptureAllGoal:Disable()
	
		self:Disable()
	end)
LossCondition:Enable()